//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

import wesual.Ui.Private 1.0

UiButton {
    id : button

    property alias buttonDelegate : buttonDelegate_.sourceComponent
    property alias popupDelegate : popupAnchor.popup

    property alias leftPadding : content.leftPadding
    property alias rightPadding : content.rightPadding
    property alias topPadding : content.topPadding
    property alias bottomPadding : content.bottomPadding

    readonly property alias open : popupAnchor.popupVisible
    readonly property bool highlight : open || pressed

    function close() {
        popupAnchor.hide();
    }

    down : popupAnchor.popupVisible
    implicitWidth : content.implicitWidth
    implicitHeight : content.implicitHeight

    onClicked : {
        if (!popupAnchor.popupVisible) {
            popupAnchor.show();
        } else {
            popupAnchor.hide();
        }
    }

    Row {
        id : content

        bottomPadding : 3
        leftPadding : 4
        rightPadding : 5
        topPadding : 3
        spacing : 4

        Loader { id : buttonDelegate_ }

        UiColorizedImage {
            anchors.verticalCenter : content.verticalCenter
            anchors.verticalCenterOffset : 1
            color : button.highlight ? "white" : "transparent"
            source : "qrc:/ui/images/dropdown-indicator.png"
        }
    }

    UiPopupAnchor {
        id : popupAnchor

        anchors {
            bottom : button.bottom
            left : button.left
        }
        popupCreationPolicy : UiPopupAnchor.OnDemandCreation

        triggerItem : button
        persistent : false
        autoLayout : true
    }
}
